/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.LinkItemMessage;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class ItemSharingModule
extends QuarkModule {
    @Config
    public static boolean renderItemsInChat = true;
    public static float alphaValue = 1.0f;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForMessage(PoseStack poseStack, FormattedCharSequence sequence, float x, float y, int color) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        StringBuilder before = new StringBuilder();
        sequence.m_13731_((counter_, style, character) -> {
            String sofar = before.toString();
            if (sofar.endsWith("    ")) {
                ItemSharingModule.render(mc, poseStack, sofar.substring(0, sofar.length() - 3), x, y, style, color);
                return false;
            }
            before.append((char)character);
            return true;
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keyboardEvent(ScreenEvent.KeyPressed.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Options settings = mc.f_91066_;
        Screen screen = event.getScreen();
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)settings.f_92098_.getKey().m_84873_()) && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (Screen.m_96638_()) {
                ItemStack stack;
                List children = gui.m_6702_();
                for (GuiEventListener c : children) {
                    EditBox tf;
                    if (!(c instanceof EditBox) || !(tf = (EditBox)c).m_93696_()) continue;
                    return;
                }
                Slot slot = gui.getSlotUnderMouse();
                if (slot != null && slot.f_40218_ != null && !(stack = slot.m_7993_()).m_41619_() && !MinecraftForge.EVENT_BUS.post((Event)new ClientChatEvent(stack.m_41611_().getString()))) {
                    QuarkNetwork.sendToServer(new LinkItemMessage(stack));
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void linkItem(Player player, ItemStack item) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class)) {
            return;
        }
        if (!item.m_41619_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Component comp = item.m_41611_();
            MutableComponent fullComp = Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{player.m_5446_(), comp});
            PlayerList players = serverPlayer.f_8924_.m_6846_();
            ServerChatEvent event = new ServerChatEvent(serverPlayer, comp.getString(), (Component)fullComp);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                players.m_215627_(event.getComponent(), ChatType.f_130598_);
                ServerGamePacketListenerImpl handler = serverPlayer.f_8906_;
                int threshold = handler.f_9750_;
                if ((threshold += 20) > 200 && !players.m_11303_(player.m_36316_())) {
                    handler.m_7026_((Component)Component.m_237115_((String)"disconnect.spam"));
                }
                handler.f_9750_ = threshold;
            }
        }
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return component;
        }
        Style style = component.m_7383_();
        if (stack.m_41613_() > 64) {
            ItemStack copyStack = stack.m_41777_();
            copyStack.m_41764_(64);
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.m_130948_(style);
        }
        MutableComponent out = Component.m_237113_((String)"   ");
        out.m_6270_(style);
        return out.m_7220_((Component)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, PoseStack pose, String before, float x, float y, Style style, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        HoverEvent hoverEvent = style.m_131186_();
        if (hoverEvent != null && hoverEvent.m_130820_() == HoverEvent.Action.f_130832_) {
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
            ItemStack itemStack = stack = contents != null ? contents.m_130898_() : ItemStack.f_41583_;
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Blocks.f_50375_);
            }
            int shift = mc.f_91062_.m_92895_(before);
            if (a > 0.0f) {
                alphaValue = a;
                PoseStack poseStack = RenderSystem.m_157191_();
                poseStack.m_85836_();
                poseStack.m_166854_(pose.m_85850_().m_85861_());
                poseStack.m_85837_((double)((float)shift + x), (double)y, 0.0);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                mc.m_91291_().m_115123_(stack, 0, 0);
                poseStack.m_85849_();
                RenderSystem.m_157182_();
                alphaValue = 1.0f;
            }
        }
    }
}

