/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import vazkii.quark.base.client.handler.InventoryButtonHandler;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SortInventoryMessage;
import vazkii.quark.content.management.client.screen.widgets.MiniInventoryButton;

@LoadModule(category=ModuleCategory.MANAGEMENT)
public class InventorySortingModule
extends QuarkModule {
    @Config
    public static boolean enablePlayerInventory = true;
    @Config
    public static boolean enablePlayerInventoryInChests = true;
    @Config
    public static boolean enableChests = true;
    @Config(description="Play a click when sorting inventories using keybindings")
    public static boolean satisfyingClick = true;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        KeyMapping sortPlayer = ModKeybindHandler.init(event, "sort_player", null, "quark.gui.keygroup.inv");
        InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.PLAYER_INVENTORY, 0, sortPlayer, screen -> {
            if (enablePlayerInventory) {
                if (satisfyingClick) {
                    this.click();
                }
                QuarkNetwork.sendToServer(new SortInventoryMessage(true));
            }
        }, this.provider("sort", true, () -> enablePlayerInventory));
        InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_PLAYER_INVENTORY, 0, sortPlayer, screen -> {
            if (enablePlayerInventoryInChests) {
                if (satisfyingClick) {
                    this.click();
                }
                QuarkNetwork.sendToServer(new SortInventoryMessage(true));
            }
        }, this.provider("sort_inventory", true, () -> enablePlayerInventoryInChests));
        InventoryButtonHandler.addButtonProvider(event, this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 0, "sort_container", screen -> {
            if (enableChests) {
                if (satisfyingClick) {
                    this.click();
                }
                QuarkNetwork.sendToServer(new SortInventoryMessage(false));
            }
        }, this.provider("sort_container", false, () -> enableChests));
    }

    @OnlyIn(value=Dist.CLIENT)
    private InventoryButtonHandler.ButtonProvider provider(String tooltip, boolean forcePlayer, BooleanSupplier condition) {
        return (parent, x, y) -> !condition.getAsBoolean() ? null : new MiniInventoryButton(parent, 0, x, y, "quark.gui.button." + tooltip, b -> QuarkNetwork.sendToServer(new SortInventoryMessage(forcePlayer)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void click() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }
}

