/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class UsageTickerModule
extends QuarkModule {
    public static List<TickerElement> elements = new ArrayList<TickerElement>();
    @Config(description="Switch the armor display to the off hand side and the hand display to the main hand side")
    public static boolean invert = false;
    @Config
    public static int shiftLeft = 0;
    @Config
    public static int shiftRight = 0;
    @Config
    public static boolean enableMainHand = true;
    @Config
    public static boolean enableOffHand = true;
    @Config
    public static boolean enableArmor = true;

    @Override
    public void configChanged() {
        elements = new ArrayList<TickerElement>();
        if (enableMainHand) {
            elements.add(new TickerElement(EquipmentSlot.MAINHAND));
        }
        if (enableOffHand) {
            elements.add(new TickerElement(EquipmentSlot.OFFHAND));
        }
        if (enableArmor) {
            elements.add(new TickerElement(EquipmentSlot.HEAD));
            elements.add(new TickerElement(EquipmentSlot.CHEST));
            elements.add(new TickerElement(EquipmentSlot.LEGS));
            elements.add(new TickerElement(EquipmentSlot.FEET));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                for (TickerElement ticker : elements) {
                    if (ticker == null) continue;
                    ticker.tick((Player)mc.f_91074_);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Window window = event.getWindow();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            float partial = event.getPartialTick();
            for (TickerElement ticker : elements) {
                if (ticker == null) continue;
                ticker.render(window, (Player)player, invert, partial);
            }
        }
    }

    public static class TickerElement {
        private static final int MAX_TIME = 60;
        private static final int ANIM_TIME = 5;
        public int liveTicks;
        public final EquipmentSlot slot;
        public ItemStack currStack = ItemStack.f_41583_;
        public ItemStack currRealStack = ItemStack.f_41583_;
        public int currCount;

        public TickerElement(EquipmentSlot slot) {
            this.slot = slot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void tick(Player player) {
            int count;
            ItemStack realStack = this.getStack(player);
            ItemStack displayedStack = this.getDisplayedStack(realStack, count = this.getStackCount(player, realStack));
            if (displayedStack.m_41619_()) {
                this.liveTicks = 0;
            } else if (this.shouldChange(realStack, this.currRealStack, count, this.currCount) || this.shouldChange(displayedStack, this.currStack, count, this.currCount)) {
                boolean animatingOut;
                boolean done = this.liveTicks == 0;
                boolean animatingIn = this.liveTicks > 55;
                boolean bl = animatingOut = this.liveTicks < 5 && !done;
                if (animatingOut) {
                    this.liveTicks = 60 - this.liveTicks;
                } else if (!animatingIn) {
                    this.liveTicks = !done ? 55 : 60;
                }
            } else if (this.liveTicks > 0) {
                --this.liveTicks;
            }
            this.currCount = count;
            this.currStack = displayedStack;
            this.currRealStack = realStack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(Window window, Player player, boolean invert, float partialTicks) {
            if (this.liveTicks > 0) {
                float mul;
                float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                float x = (float)window.m_85445_() / 2.0f;
                float y = (float)window.m_85446_() - anim;
                int barWidth = 190;
                boolean armor = this.slot.m_20743_() == EquipmentSlot.Type.ARMOR;
                HumanoidArm primary = player.m_5737_();
                HumanoidArm ourSide = armor != invert ? primary : primary.m_20828_();
                int slots = armor ? 4 : 2;
                int index = slots - this.slot.m_20749_() - 1;
                float f = mul = ourSide == HumanoidArm.LEFT ? -1.0f : 1.0f;
                if (ourSide != primary && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                    barWidth += 58;
                }
                Minecraft mc = Minecraft.m_91087_();
                x += (float)barWidth / 2.0f * mul + (float)(index * 20);
                if (ourSide == HumanoidArm.LEFT) {
                    x -= (float)(slots * 20);
                    x += (float)shiftLeft;
                } else {
                    x += (float)shiftRight;
                }
                ItemStack stack = this.getRenderedStack(player);
                mc.m_91291_().m_115203_(stack, (int)x, (int)y);
                mc.m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, stack, (int)x, (int)y);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
            return !prevStack.m_41656_(currStack) || currStack.m_41763_() && currStack.m_41773_() != prevStack.m_41773_() || currentTotal != pastTotal;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getStack(Player player) {
            return player.m_6844_(this.slot);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getDisplayedStack(ItemStack stack, int count) {
            boolean verifySize = true;
            if ((stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) == 0) {
                stack = new ItemStack((ItemLike)Items.f_42412_);
                verifySize = false;
            } else {
                Item item = stack.m_41720_();
                if (item instanceof IUsageTickerOverride) {
                    IUsageTickerOverride over = (IUsageTickerOverride)item;
                    stack = over.getUsageTickerItem(stack);
                    verifySize = over.shouldUsageTickerCheckMatchSize(this.currStack);
                }
            }
            if (!stack.m_41753_() && this.slot.m_20743_() == EquipmentSlot.Type.HAND) {
                return ItemStack.f_41583_;
            }
            if (verifySize && stack.m_41753_() && count == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            return stack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getRenderedStack(Player player) {
            int count;
            ItemStack stack = this.getStack(player);
            ItemStack displayStack = this.getDisplayedStack(stack, count = this.getStackCount(player, stack)).m_41777_();
            if (displayStack != stack) {
                count = this.getStackCount(player, displayStack);
            }
            displayStack.m_41764_(count);
            return displayStack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getStackCount(Player player, ItemStack stack) {
            if (!stack.m_41753_()) {
                return 1;
            }
            Predicate<ItemStack> predicate = stackAt -> ItemStack.m_41746_((ItemStack)stackAt, (ItemStack)stack) && ItemStack.m_41658_((ItemStack)stackAt, (ItemStack)stack);
            if (stack.m_41720_() == Items.f_42412_) {
                predicate = stackAt -> stackAt.m_41720_() instanceof ArrowItem;
            }
            int total = 0;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stackAt2 = inventory.m_8020_(i);
                if (predicate.test(stackAt2)) {
                    total += stackAt2.m_41613_();
                    continue;
                }
                Item item = stackAt2.m_41720_();
                if (!(item instanceof IUsageTickerOverride)) continue;
                IUsageTickerOverride over = (IUsageTickerOverride)item;
                total += over.getUsageTickerCountForItem(stackAt2, predicate);
            }
            return total;
        }
    }
}

