/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.ConvulsionMatrixConfig;
import vazkii.quark.mixin.client.accessor.AccessorBlockColors;

@LoadModule(category=ModuleCategory.CLIENT)
public class GreenerGrassModule
extends QuarkModule {
    @Config
    public static boolean affectLeaves = true;
    @Config
    public static List<String> blockList = Lists.newArrayList((Object[])new String[]{"minecraft:large_fern", "minecraft:tall_grass", "minecraft:grass_block", "minecraft:fern", "minecraft:grass", "minecraft:potted_fern", "minecraft:sugar_cane", "environmental:giant_tall_grass", "valhelsia_structures:grass_block"});
    @Config
    public static List<String> leavesList = Lists.newArrayList((Object[])new String[]{"minecraft:spruce_leaves", "minecraft:birch_leaves", "minecraft:oak_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "atmospheric:rosewood_leaves", "atmospheric:morado_leaves", "atmospheric:yucca_leaves", "autumnity:maple_leaves", "environmental:willow_leaves", "environmental:hanging_willow_leaves", "minecraft:vine"});
    @Config
    public static ConvulsionMatrixConfig colorMatrix = new ConvulsionMatrixConfig(new double[]{0.89, 0.0, 0.0, 0.0, 1.11, 0.0, 0.0, 0.0, 0.89});

    @Override
    public void firstClientTick() {
        this.registerGreenerColor(blockList, false);
        this.registerGreenerColor(leavesList, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerGreenerColor(Iterable<String> ids, boolean leaves) {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        Map<Holder.Reference<Block>, BlockColor> map = ((AccessorBlockColors)colors).quark$getBlockColors();
        for (String id : ids) {
            Holder.Reference delegate;
            BlockColor color;
            Optional optDelegate;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (block == null || (optDelegate = ForgeRegistries.BLOCKS.getDelegate((Object)block)) == null || !optDelegate.isPresent() || (color = map.get(delegate = (Holder.Reference)optDelegate.get())) == null) continue;
            colors.m_92589_(this.getGreenerColor(color, leaves), new Block[]{block});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private BlockColor getGreenerColor(BlockColor color, boolean leaves) {
        return (state, world, pos, tintIndex) -> {
            int originalColor = color.m_92566_(state, world, pos, tintIndex);
            if (!this.enabled || leaves && !affectLeaves) {
                return originalColor;
            }
            return colorMatrix.convolve(originalColor);
        };
    }
}

