/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class WoodPostBlock
extends QuarkBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.m_61465_((String)"chain_down"), BooleanProperty.m_61465_((String)"chain_up"), BooleanProperty.m_61465_((String)"chain_north"), BooleanProperty.m_61465_((String)"chain_south"), BooleanProperty.m_61465_((String)"chain_west"), BooleanProperty.m_61465_((String)"chain_east")};

    public WoodPostBlock(QuarkModule module, Block parent, String prefix, boolean nether) {
        super(IQuarkBlock.inherit(parent, (String s) -> prefix + s.replace("_fence", "_post")), module, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent).m_60918_(nether ? SoundType.f_56763_ : SoundType.f_56736_));
        BlockState state = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty prop : CHAINED) {
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            default -> SHAPE_Z;
        };
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState(context.m_43725_(), context.m_8083_(), context.m_43719_().m_122434_());
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockState newState = this.getState(worldIn, pos, (Direction.Axis)state.m_61143_(AXIS));
        if (!newState.equals(state)) {
            worldIn.m_46597_(pos, newState);
        }
    }

    private BlockState getState(Level world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_(AXIS, (Comparable)axis);
        for (Direction d : Direction.values()) {
            BlockState sideState;
            if (d.m_122434_() == axis || (!((sideState = world.m_8055_(pos.m_121945_(d))).m_60734_() instanceof ChainBlock) || sideState.m_61143_((Property)BlockStateProperties.f_61365_) != d.m_122434_()) && (d != Direction.DOWN || !(sideState.m_60734_() instanceof LanternBlock) || !((Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_)).booleanValue())) continue;
            BooleanProperty prop = CHAINED[d.ordinal()];
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty prop : CHAINED) {
            builder.m_61104_(new Property[]{prop});
        }
    }
}

