/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.ModList;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.be.VariantChestBlockEntity;
import vazkii.quark.content.building.module.VariantChestsModule;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantChestBlock
extends ChestBlock
implements IBlockItemProvider,
IQuarkBlock,
VariantChestsModule.IChestTextureProvider {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;
    private final String path;

    public VariantChestBlock(String type, QuarkModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
        super(props, supplier);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_chest"));
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
        this.module = module;
        this.path = (this instanceof Compat ? "compat/" : "") + type + "/";
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public VariantChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new VariantChestBlockEntity(pos, state);
    }

    @Override
    public String getChestTexturePath() {
        return "model/chest/" + this.path;
    }

    @Override
    public boolean isTrap() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        return new Item(block, props);
    }

    public static class Compat
    extends VariantChestBlock {
        public Compat(String type, String mod, QuarkModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
            super(type, module, supplier, props);
            this.setCondition(() -> ModList.get().isLoaded(mod));
        }
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    final Minecraft mc = Minecraft.m_91087_();
                    return new BlockEntityWithoutLevelRenderer(mc.m_167982_(), mc.m_167973_()){
                        private final BlockEntity tile;
                        {
                            super(p_172550_, p_172551_);
                            this.tile = new VariantChestBlockEntity(BlockPos.f_121853_, this.m_40614_().m_49966_());
                        }

                        public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemTransforms.TransformType transformType, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, int x, int y) {
                            mc.m_167982_().m_112272_(this.tile, pose, buffer, x, y);
                        }
                    };
                }
            });
        }
    }
}

