/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IIndirectConnector;
import vazkii.quark.api.IPistonCallback;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class PistonsMoveTileEntitiesModule
extends QuarkModule {
    private static final WeakHashMap<Level, Map<BlockPos, CompoundTag>> movements = new WeakHashMap();
    private static final WeakHashMap<Level, List<Pair<BlockPos, CompoundTag>>> delayedUpdates = new WeakHashMap();
    @Config
    public static boolean enableChestsMovingTogether = true;
    public static boolean staticEnabled;
    @Config
    public static List<String> renderBlacklist;
    @Config
    public static List<String> movementBlacklist;
    @Config
    public static List<String> delayedUpdateList;

    @Override
    public void register() {
        IIndirectConnector.INDIRECT_STICKY_BLOCKS.add((Pair<Predicate<BlockState>, IIndirectConnector>)Pair.of(ChestConnection.PREDICATE, (Object)ChestConnection.INSTANCE));
    }

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!delayedUpdates.containsKey(event.level) || event.phase == TickEvent.Phase.START) {
            return;
        }
        List<Pair<BlockPos, CompoundTag>> delays = delayedUpdates.get(event.level);
        if (delays.isEmpty()) {
            return;
        }
        for (Pair<BlockPos, CompoundTag> delay : delays) {
            BlockState state;
            BlockPos pos = (BlockPos)delay.getLeft();
            BlockEntity tile = BlockEntity.m_155241_((BlockPos)pos, (BlockState)(state = event.level.m_8055_(pos)), (CompoundTag)((CompoundTag)delay.getRight()));
            if (tile != null) {
                tile.m_155250_(state);
                tile.m_6596_();
                event.level.m_151523_(tile);
            }
            event.level.m_46717_(pos, state.m_60734_());
        }
        delays.clear();
    }

    public static boolean shouldMoveTE(boolean te, BlockState state) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return te;
        }
        return PistonsMoveTileEntitiesModule.shouldMoveTE(state);
    }

    public static boolean shouldMoveTE(BlockState state) {
        if (state.m_61148_().containsKey((Object)JukeboxBlock.f_54254_) && ((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50040_) {
            return true;
        }
        ResourceLocation res = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        return res == null || movementBlacklist.contains(res.toString()) || movementBlacklist.contains(res.m_135827_());
    }

    public static void detachTileEntities(Level world, PistonStructureResolver helper, Direction facing, boolean extending) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return;
        }
        if (!extending) {
            facing = facing.m_122424_();
        }
        List moveList = helper.m_60436_();
        for (BlockPos pos : moveList) {
            BlockEntity tile;
            BlockState state = world.m_8055_(pos);
            if (!(state.m_60734_() instanceof EntityBlock) || (tile = world.m_7702_(pos)) == null) continue;
            if (PistonsMoveTileEntitiesModule.hasCallback(tile)) {
                PistonsMoveTileEntitiesModule.getCallback(tile).onPistonMovementStarted();
            }
            world.m_46747_(pos);
            PistonsMoveTileEntitiesModule.registerMovement(world, pos.m_121945_(facing), tile);
        }
    }

    public static boolean setPistonBlock(Level world, BlockPos pos, BlockState state, int flags) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            world.m_7731_(pos, state, flags);
            return false;
        }
        if (!enableChestsMovingTogether && state.m_61148_().containsKey((Object)ChestBlock.f_51479_)) {
            state = (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.SINGLE);
        }
        Block block = state.m_60734_();
        BlockEntity entity = PistonsMoveTileEntitiesModule.getAndClearMovement(world, pos);
        boolean destroyed = false;
        if (entity != null) {
            BlockState currState = world.m_8055_(pos);
            BlockEntity currEntity = world.m_7702_(pos);
            world.m_7471_(pos, false);
            if (!block.m_7898_(state, (LevelReader)world, pos)) {
                world.m_7731_(pos, state, flags);
                world.m_151523_(entity);
                Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
                world.m_7471_(pos, false);
                destroyed = true;
            }
            if (!destroyed) {
                world.m_46597_(pos, currState);
                if (currEntity != null) {
                    world.m_151523_(currEntity);
                }
            }
        }
        if (!destroyed) {
            world.m_7731_(pos, state, flags);
            if (world.m_7702_(pos) != null) {
                world.m_7731_(pos, state, 0);
            }
            if (entity != null && !world.f_46443_) {
                if (delayedUpdateList.contains(Objects.toString(Registry.f_122824_.m_7981_((Object)block)))) {
                    PistonsMoveTileEntitiesModule.registerDelayedUpdate(world, pos, entity);
                } else {
                    entity.m_155250_(state);
                    entity.m_6596_();
                    world.m_151523_(entity);
                }
            }
            world.m_46672_(pos, block);
        }
        return false;
    }

    private static void registerMovement(Level world, BlockPos pos, BlockEntity tile) {
        if (!movements.containsKey(world)) {
            movements.put(world, new HashMap());
        }
        movements.get(world).put(pos, tile.m_187480_());
    }

    public static BlockEntity getMovement(Level world, BlockPos pos) {
        return PistonsMoveTileEntitiesModule.getMovement(world, pos, false);
    }

    private static BlockEntity getMovement(Level world, BlockPos pos, boolean remove) {
        if (!movements.containsKey(world)) {
            return null;
        }
        Map<BlockPos, CompoundTag> worldMovements = movements.get(world);
        if (!worldMovements.containsKey(pos)) {
            return null;
        }
        CompoundTag ret = worldMovements.get(pos);
        if (remove) {
            worldMovements.remove(pos);
        }
        return BlockEntity.m_155241_((BlockPos)pos, (BlockState)world.m_8055_(pos), (CompoundTag)ret);
    }

    private static BlockEntity getAndClearMovement(Level world, BlockPos pos) {
        BlockEntity tile = PistonsMoveTileEntitiesModule.getMovement(world, pos, true);
        if (tile != null) {
            if (PistonsMoveTileEntitiesModule.hasCallback(tile)) {
                PistonsMoveTileEntitiesModule.getCallback(tile).onPistonMovementFinished();
            }
            tile.m_142339_(world);
            tile.m_6339_();
        }
        return tile;
    }

    private static void registerDelayedUpdate(Level world, BlockPos pos, BlockEntity tile) {
        if (!delayedUpdates.containsKey(world)) {
            delayedUpdates.put(world, new ArrayList());
        }
        delayedUpdates.get(world).add((Pair<BlockPos, CompoundTag>)Pair.of((Object)pos, (Object)tile.m_187480_()));
    }

    private static boolean hasCallback(BlockEntity tile) {
        return tile.getCapability(QuarkCapabilities.PISTON_CALLBACK).isPresent();
    }

    private static IPistonCallback getCallback(BlockEntity tile) {
        return (IPistonCallback)tile.getCapability(QuarkCapabilities.PISTON_CALLBACK).orElse(() -> {});
    }

    static {
        renderBlacklist = Lists.newArrayList((Object[])new String[]{"psi:programmer", "botania:starfield"});
        movementBlacklist = Lists.newArrayList((Object[])new String[]{"minecraft:spawner", "integrateddynamics:cable", "randomthings:blockbreaker", "minecraft:ender_chest", "minecraft:enchanting_table", "minecraft:trapped_chest", "quark:spruce_trapped_chest", "quark:birch_trapped_chest", "quark:jungle_trapped_chest", "quark:acacia_trapped_chest", "quark:dark_oak_trapped_chest", "endergetic:bolloom_bud"});
        delayedUpdateList = Lists.newArrayList((Object[])new String[]{"minecraft:dispenser", "minecraft:dropper"});
    }

    public static class ChestConnection
    implements IIndirectConnector {
        public static ChestConnection INSTANCE = new ChestConnection();
        public static Predicate<BlockState> PREDICATE = ChestConnection::isValidState;

        @Override
        public boolean isEnabled() {
            return enableChestsMovingTogether;
        }

        private static boolean isValidState(BlockState state) {
            if (!(state.m_60734_() instanceof ChestBlock)) {
                return false;
            }
            ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            return type != ChestType.SINGLE;
        }

        @Override
        public boolean canConnectIndirectly(Level world, BlockPos ourPos, BlockPos sourcePos, BlockState ourState, BlockState sourceState) {
            ChestType ourType = (ChestType)ourState.m_61143_((Property)ChestBlock.f_51479_);
            Direction baseDirection = (Direction)ourState.m_61143_((Property)ChestBlock.f_51478_);
            Direction targetDirection = ourType == ChestType.LEFT ? baseDirection.m_122427_() : baseDirection.m_122428_();
            BlockPos targetPos = ourPos.m_121945_(targetDirection);
            return targetPos.equals((Object)sourcePos);
        }
    }
}

