/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.config.ConfigFlagManager;

public record FlagRecipeCondition(ConfigFlagManager manager, String flag, ResourceLocation loc) implements ICondition
{
    public ResourceLocation getID() {
        return this.loc;
    }

    public boolean test(ICondition.IContext context) {
        if (this.flag.contains("%")) {
            throw new RuntimeException("Illegal flag: " + this.flag);
        }
        if (!this.manager.isValidFlag(this.flag)) {
            Quark.LOG.warn("Non-existant flag " + this.flag + " being used");
        }
        return this.manager.getFlag(this.flag);
    }

    public static class Serializer
    implements IConditionSerializer<FlagRecipeCondition> {
        private final ConfigFlagManager manager;
        private final ResourceLocation location;

        public Serializer(ConfigFlagManager manager, ResourceLocation location) {
            this.manager = manager;
            this.location = location;
        }

        public void write(JsonObject json, FlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public FlagRecipeCondition read(JsonObject json) {
            return new FlagRecipeCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString(), this.location);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

