/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.item;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class QuarkMusicDiscItem
extends RecordItem
implements IQuarkItem {
    private final QuarkModule module;
    private final boolean isAmbient;
    private final Supplier<SoundEvent> soundSupplier;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkMusicDiscItem(int comparatorValue, Supplier<SoundEvent> sound, String name, QuarkModule module, boolean isAmbient) {
        super(comparatorValue, sound, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)("music_disc_" + name));
        this.module = module;
        this.isAmbient = isAmbient;
        this.soundSupplier = sound;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_6787_(group, items);
        }
    }

    @Override
    public QuarkMusicDiscItem setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean playAmbientSound(BlockPos pos) {
        if (this.isAmbient) {
            Minecraft mc = Minecraft.m_91087_();
            SoundManager soundEngine = mc.m_91106_();
            LevelRenderer render = mc.f_91060_;
            SimpleSoundInstance simplesound = new SimpleSoundInstance(this.soundSupplier.get().m_11660_(), SoundSource.RECORDS, 4.0f, 1.0f, SoundInstance.m_235150_(), true, 0, SoundInstance.Attenuation.LINEAR, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), false);
            render.f_109410_.put(pos, simplesound);
            soundEngine.m_120367_((SoundInstance)simplesound);
            if (mc.f_91073_ != null) {
                mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + Math.random(), Math.random(), 0.0, 0.0);
            }
            return true;
        }
        return false;
    }
}

