/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.quark.base.client.config.screen.AbstractQScreen;
import vazkii.quark.content.experimental.module.EnchantmentsBegoneModule;
import vazkii.quark.mixin.accessor.AccessorLootTable;

@Mod.EventBusSubscriber(modid="quark")
public class MiscUtil {
    public static final ResourceLocation GENERAL_ICONS = new ResourceLocation("quark", "textures/gui/general_icons.png");
    public static final ResourceLocation ATTRIBUTE_ICONS = new ResourceLocation("quark", "textures/gui/attribute_icons.png");
    public static final int BASIC_GUI_TEXT_COLOR = 0x404040;
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static int progress;

    public static void addToLootTable(LootTable table, LootPoolEntryContainer entry) {
        List<LootPool> pools = ((AccessorLootTable)table).quark$getPools();
        if (pools != null && !pools.isEmpty()) {
            LootPool firstPool = pools.get(0);
            LootPoolEntryContainer[] entries = firstPool.f_79023_;
            LootPoolEntryContainer[] newEntries = new LootPoolEntryContainer[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[entries.length] = entry;
            firstPool.f_79023_ = newEntries;
        }
    }

    public static void damageStack(Player player, InteractionHand hand, ItemStack stack, int dmg) {
        stack.m_41622_(dmg, (LivingEntity)player, p -> p.m_21190_(hand));
    }

    public static <T, V> void editFinalField(Class<T> clazz, String fieldName, Object obj, V value) {
        Field f = ObfuscationReflectionHelper.findField(clazz, (String)fieldName);
        MiscUtil.editFinalField(f, obj, value);
    }

    public static <T> void editFinalField(Field f, Object obj, T value) {
        try {
            f.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(obj, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initializeEnchantmentList(Iterable<String> enchantNames, List<Enchantment> enchants) {
        enchants.clear();
        for (String s : enchantNames) {
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (enchant == null || EnchantmentsBegoneModule.shouldBegone(enchant)) continue;
            enchants.add(enchant);
        }
    }

    public static Vec2 getMinecraftAngles(Vec3 direction) {
        direction = direction.m_82541_();
        double pitch = Math.asin(direction.f_82480_);
        double yaw = Math.asin(direction.f_82479_ / Math.cos(pitch));
        return new Vec2((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static boolean isEntityInsideOpaqueBlock(Entity entity) {
        BlockPos pos = entity.m_20183_();
        return !entity.f_19794_ && entity.f_19853_.m_8055_(pos).m_60828_((BlockGetter)entity.f_19853_, pos);
    }

    public static boolean validSpawnLight(ServerLevelAccessor world, BlockPos pos, RandomSource rand) {
        if (world.m_45517_(LightLayer.SKY, pos) > rand.m_188503_(32)) {
            return false;
        }
        int light = world.m_6018_().m_46470_() ? world.m_46849_(pos, 10) : world.m_46803_(pos);
        return light == 0;
    }

    public static boolean validSpawnLocation(@Nonnull EntityType<? extends Mob> type, @Nonnull LevelAccessor world, MobSpawnType reason, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        BlockState state = world.m_8055_(below);
        return state.m_60767_() == Material.f_76278_ && state.m_60643_((BlockGetter)world, below, type);
    }

    public static <T> List<T> massRegistryGet(Collection<String> coll, IForgeRegistry<T> registry) {
        return coll.stream().map(ResourceLocation::new).map(arg_0 -> registry.getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void syncTE(BlockEntity tile) {
        Level level;
        Packet packet = tile.m_58483_();
        if (packet != null && (level = tile.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false).forEach(e -> e.f_8906_.m_9829_(packet));
        }
    }

    public static ItemStack putIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean simulate, boolean doSimulation) {
        Block block;
        IItemHandler handler = null;
        if (level != null && blockPos != null && (block = level.m_8055_(blockPos).m_60734_()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            handler = new SidedInvWrapper(holder.m_5840_(level.m_8055_(blockPos), level, blockPos), face);
        } else if (tile != null) {
            LazyOptional opt = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
            if (opt.isPresent()) {
                handler = (IItemHandler)opt.orElse((Object)new ItemStackHandler());
            } else if (tile instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)tile;
                handler = new SidedInvWrapper(container, face);
            } else if (tile instanceof Container) {
                Container container = (Container)tile;
                handler = new InvWrapper(container);
            }
        }
        if (handler != null) {
            return simulate && !doSimulation ? ItemStack.f_41583_ : ItemHandlerHelper.insertItem(handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public static boolean canPutIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean doSimulation) {
        return MiscUtil.putIntoInv(stack, level, blockPos, tile, face, true, doSimulation).m_41619_();
    }

    public static <T> List<T> getTagValues(RegistryAccess access, TagKey<T> tag) {
        Registry registry = access.m_175515_(tag.f_203867_());
        HolderSet holderSet = (HolderSet)registry.m_203431_(tag).orElse(new HolderSet.Named(registry, tag));
        return holderSet.m_203614_().map(Holder::m_203334_).toList();
    }

    public static String toColorString(int color) {
        String colorString = Integer.toHexString(color);
        int targetLength = colorString.length() > 6 ? 8 : 6;
        String zeroes = colorString.length() < targetLength ? "0".repeat(targetLength - colorString.length()) : "";
        return "#" + zeroes + colorString;
    }

    public static int getAsColor(JsonObject object, String key) {
        if (object.has(key)) {
            return MiscUtil.convertToColor(object.get(key), key);
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find an item");
    }

    public static int convertToColor(JsonElement element, String key) {
        if (element.isJsonPrimitive()) {
            String s;
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsInt();
            }
            if (primitive.isString() && (s = element.getAsString()).matches("#[0-9a-f]{6}")) {
                try {
                    return Integer.parseInt(s.substring(1), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new JsonSyntaxException("Expected " + key + " to be a color, was " + GsonHelper.m_13883_((JsonElement)element));
    }

    public static BlockState fromString(String key) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(key), (boolean)false);
            BlockState state = result.f_234748_();
            return state == null ? Blocks.f_50016_.m_49966_() : state;
        }
        catch (CommandSyntaxException e) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGuiTextColor(String name) {
        return MiscUtil.getGuiTextColor(name, 0x404040);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGuiTextColor(String name, int base) {
        int ret = base;
        String hex = I18n.m_118938_((String)("quark.gui.color." + name), (Object[])new Object[0]);
        if (hex.matches("#[A-F0-9]{6}")) {
            ret = Integer.valueOf(hex.substring(1), 16);
        }
        return ret;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeystroke(ScreenEvent.KeyPressed.Pre event) {
        String[] ids = new String[]{"-FCYE87P5L0", "mybsDDymrsc", "6a4BWpBJppI", "thpTOAS1Vgg", "ZNcBZM5SvbY", "_qJEoSa3Ie0", "RWeyOyY_puQ", "VBbeuXW8Nko", "LIDe-yTxda0", "BVVfMFS3mgc", "m5qwcYL8a0o", "UkY8HvgvBJ8", "4K4b9Z9lSwc", "tyInv6RWL0Q", "tIWpr3tHzII", "AFJPFfnzZ7w", "846cjX0ZTrk", "XEOCbFJjRw0", "GEo5bmUKFvI", "b6li05zh3Kg", "_EEo-iE5u_A", "SPYX2y4NzTU"};
        int[] keys = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
        if (event.getScreen() instanceof AbstractQScreen) {
            if (keys[progress] == event.getKeyCode()) {
                if (++progress >= keys.length) {
                    progress = 0;
                    Util.m_137581_().m_137646_("https://www.youtube.com/watch?v=" + ids[new Random().nextInt(ids.length)]);
                }
            } else {
                progress = 0;
            }
        }
    }
}

