/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.recipe.ingredient.FlagIngredient;
import vazkii.quark.mixin.accessor.AccessorPotionBrewing;

public class BrewingHandler {
    private static boolean isInjectionPrepared = false;
    private static final List<Triple<Potion, Supplier<Ingredient>, Potion>> toRegister = Lists.newArrayList();

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, MobEffect effect) {
        BrewingHandler.addPotionMix(flag, reagent, effect, null);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, MobEffect effect, int normalTime, int longTime, int strongTime) {
        BrewingHandler.addPotionMix(flag, reagent, effect, null, normalTime, longTime, strongTime);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, MobEffect effect, @Nullable MobEffect negation) {
        BrewingHandler.addPotionMix(flag, reagent, effect, negation, 3600, 9600, 1800);
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, MobEffect effect, @Nullable MobEffect negation, int normalTime, int longTime, int strongTime) {
        ResourceLocation loc = RegistryHelper.getRegistryName((Object)effect, (Registry)Registry.f_122823_);
        if (loc != null) {
            ResourceLocation negationLoc;
            String baseName = loc.m_135815_();
            boolean hasStrong = strongTime > 0;
            Potion normalType = BrewingHandler.addPotion(new MobEffectInstance(effect, normalTime), baseName, baseName);
            Potion longType = BrewingHandler.addPotion(new MobEffectInstance(effect, longTime), baseName, "long_" + baseName);
            Potion strongType = !hasStrong ? null : BrewingHandler.addPotion(new MobEffectInstance(effect, strongTime, 1), baseName, "strong_" + baseName);
            BrewingHandler.addPotionMix(flag, reagent, normalType, longType, strongType);
            if (negation != null && (negationLoc = RegistryHelper.getRegistryName((Object)negation, (Registry)Registry.f_122823_)) != null) {
                String negationBaseName = negationLoc.m_135815_();
                Potion normalNegationType = BrewingHandler.addPotion(new MobEffectInstance(negation, normalTime), negationBaseName, negationBaseName);
                Potion longNegationType = BrewingHandler.addPotion(new MobEffectInstance(negation, longTime), negationBaseName, "long_" + negationBaseName);
                Potion strongNegationType = !hasStrong ? null : BrewingHandler.addPotion(new MobEffectInstance(negation, strongTime, 1), negationBaseName, "strong_" + negationBaseName);
                BrewingHandler.addNegation(flag, normalType, longType, strongType, normalNegationType, longNegationType, strongNegationType);
            }
        }
    }

    public static void addPotionMix(String flag, Supplier<Ingredient> reagent, Potion normalType, Potion longType, @Nullable Potion strongType) {
        boolean hasStrong = strongType != null;
        BrewingHandler.add(flag, Potions.f_43602_, reagent, normalType);
        BrewingHandler.add(flag, Potions.f_43599_, reagent, Potions.f_43600_);
        if (hasStrong) {
            BrewingHandler.add(flag, normalType, BrewingHandler::glowstone, strongType);
        }
        BrewingHandler.add(flag, normalType, BrewingHandler::redstone, longType);
    }

    public static void addNegation(String flag, Potion normalType, Potion longType, @Nullable Potion strongType, Potion normalNegatedType, Potion longNegatedType, @Nullable Potion strongNegatedType) {
        boolean hasStrong;
        BrewingHandler.add(flag, normalType, BrewingHandler::spiderEye, normalNegatedType);
        boolean bl = hasStrong = strongType != null && strongNegatedType != null;
        if (hasStrong) {
            BrewingHandler.add(flag, strongType, BrewingHandler::spiderEye, strongNegatedType);
            BrewingHandler.add(flag, normalNegatedType, BrewingHandler::glowstone, strongNegatedType);
        }
        BrewingHandler.add(flag, longType, BrewingHandler::spiderEye, longNegatedType);
        BrewingHandler.add(flag, normalNegatedType, BrewingHandler::redstone, longNegatedType);
    }

    public static ItemStack of(Item potionType, Potion potion) {
        ItemStack stack = new ItemStack((ItemLike)potionType);
        PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
        return stack;
    }

    public static void setup() {
        isInjectionPrepared = true;
        for (Triple<Potion, Supplier<Ingredient>, Potion> triple : toRegister) {
            BrewingHandler.addBrewingRecipe((Potion)triple.getLeft(), (Ingredient)((Supplier)triple.getMiddle()).get(), (Potion)triple.getRight());
        }
        toRegister.clear();
    }

    private static void add(String flag, Potion potion, Supplier<Ingredient> reagent, Potion to) {
        if (isInjectionPrepared) {
            BrewingHandler.addBrewingRecipe(potion, new FlagIngredient(reagent.get(), flag), to);
        } else {
            toRegister.add((Triple<Potion, Supplier<Ingredient>, Potion>)new ImmutableTriple((Object)potion, () -> new FlagIngredient((Ingredient)reagent.get(), flag), (Object)to));
        }
    }

    private static void addBrewingRecipe(Potion input, Ingredient reagent, Potion output) {
        AccessorPotionBrewing.quark$getPotionMixes().add((PotionBrewing.Mix<Potion>)new PotionBrewing.Mix(ForgeRegistries.POTIONS, (Object)input, reagent, (Object)output));
    }

    private static Potion addPotion(MobEffectInstance eff, String baseName, String name) {
        Potion effect = new Potion("quark." + baseName, new MobEffectInstance[]{eff});
        RegistryHelper.register((Object)effect, (String)name, (ResourceKey)Registry.f_122905_);
        return effect;
    }

    private static Ingredient redstone() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_});
    }

    private static Ingredient glowstone() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_});
    }

    private static Ingredient spiderEye() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_});
    }
}

