/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.time.Month;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.client.config.screen.QuarkConfigHomeScreen;
import vazkii.quark.base.client.handler.TopLayerTooltipHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.MiscUtil;

public class QButton
extends Button {
    private static final int ORANGE = 1;
    private static final int PURPLE = 2;
    private static final int RAINBOW = 3;
    private static final int QUARK = 4;
    private static final List<Celebration> CELEBRATIONS = new ArrayList<Celebration>();
    private final boolean gay;
    private Celebration celebrating;

    private static void celebrate(String name, int day, Month month, int tier) {
        QButton.celebrate(name, day, day, month, tier);
    }

    private static void celebrate(String name, int day, int end, Month month, int tier) {
        CELEBRATIONS.add(new Celebration(day, month.getValue(), end - day, tier, name));
    }

    public QButton(int x, int y) {
        super(x, y, 20, 20, (Component)Component.m_237113_((String)"q"), QButton::click);
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.gay = month == 6;
        for (Celebration c : CELEBRATIONS) {
            if (!c.running(day, month)) continue;
            this.celebrating = c;
            break;
        }
    }

    public int getFGColor() {
        return this.gay ? Color.HSBtoRGB(ClientTicker.total / 200.0f, 1.0f, 1.0f) : 4775356;
    }

    public void m_6303_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(mstack, mouseX, mouseY, partialTicks);
        int iconIndex = Math.min(4, ContributorRewardHandler.localPatronTier);
        if (this.celebrating != null) {
            iconIndex = this.celebrating.tier;
        }
        if (iconIndex > 0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
            int rx = this.f_93620_ - 2;
            int ry = this.f_93621_ - 2;
            int w = 9;
            int h = 9;
            int v = 26;
            if (this.celebrating != null) {
                boolean hovered;
                rx -= 3;
                ry -= 2;
                w = 10;
                h = 10;
                v = 44;
                boolean bl = hovered = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                if (hovered) {
                    TopLayerTooltipHandler.setTooltip(List.of(I18n.m_118938_((String)("quark.gui.celebration." + this.celebrating.name), (Object[])new Object[0])), mouseX, mouseY);
                }
            }
            int u = 256 - iconIndex * w;
            this.m_93228_(mstack, rx, ry, u, v, w, h);
        }
    }

    public static void click(Button b) {
        Minecraft.m_91087_().m_91152_((Screen)new QuarkConfigHomeScreen(Minecraft.m_91087_().f_91080_));
    }

    static {
        QButton.celebrate("quark", 21, Month.MARCH, 4);
        QButton.celebrate("vm", 29, Month.APRIL, 2);
        QButton.celebrate("minecraft", 18, Month.NOVEMBER, 1);
        QButton.celebrate("vns", 9, Month.APRIL, 1);
        QButton.celebrate("vazkii", 22, Month.NOVEMBER, 1);
        QButton.celebrate("wire", 23, Month.SEPTEMBER, 1);
        QButton.celebrate("iad", 6, Month.APRIL, 3);
        QButton.celebrate("iad2", 26, Month.OCTOBER, 3);
        QButton.celebrate("idr", 8, Month.NOVEMBER, 3);
        QButton.celebrate("ld", 8, Month.OCTOBER, 3);
        QButton.celebrate("lvd", 26, Month.APRIL, 3);
        QButton.celebrate("ncod", 11, Month.OCTOBER, 3);
        QButton.celebrate("nbpd", 14, Month.JULY, 3);
        QButton.celebrate("ppad", 24, Month.MAY, 3);
        QButton.celebrate("tdr", 20, Month.NOVEMBER, 3);
        QButton.celebrate("tdv", 31, Month.MARCH, 3);
        QButton.celebrate("zdd", 1, Month.MARCH, 3);
        QButton.celebrate("afd", 1, Month.APRIL, 4);
        QButton.celebrate("wwd", 3, Month.MARCH, 2);
        QButton.celebrate("hw", 31, Month.OCTOBER, 1);
        QButton.celebrate("xmas", 25, Month.DECEMBER, 2);
        QButton.celebrate("iwd", 8, Month.MARCH, 2);
        QButton.celebrate("wpld", 5, Month.MAY, 2);
        QButton.celebrate("iyd", 12, Month.AUGUST, 2);
        QButton.celebrate("hrd", 9, Month.DECEMBER, 2);
        QButton.celebrate("ny", 1, 3, Month.JANUARY, 2);
        QButton.celebrate("doyouremember", 21, Month.SEPTEMBER, 1);
        QButton.celebrate("pm", 1, 30, Month.JUNE, 3);
        QButton.celebrate("baw", 16, 22, Month.SEPTEMBER, 3);
        QButton.celebrate("taw", 13, 19, Month.NOVEMBER, 3);
    }

    private record Celebration(int day, int month, int len, int tier, String name) {
        public boolean running(int day, int month) {
            return this.month == month && this.day >= day && this.day <= day + this.len;
        }
    }
}

