/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.block.TinyPotatoBlock;
import vazkii.quark.addons.oddities.util.TinyPotatoInfo;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.base.handler.ContributorRewardHandler;

public class TinyPotatoBlockItem
extends BlockItem
implements IRuneColorProvider {
    private static final int NOT_MY_NAME = 17;
    private static final List<String> TYPOS = List.of("vaskii", "vazki", "voskii", "vazkkii", "vazkki", "vazzki", "vaskki", "vozkii", "vazkil", "vaskil", "vazkill", "vaskill", "vaski");
    private static final String TICKS = "notMyNameTicks";

    public TinyPotatoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        Player player;
        return super.canEquip(stack, armorType, entity) || entity instanceof Player && ContributorRewardHandler.getTier(player = (Player)entity) > 0;
    }

    @Nonnull
    public String m_5671_(@Nonnull ItemStack stack) {
        if (TinyPotatoBlock.isAngry(stack)) {
            return super.m_5671_(stack) + ".angry";
        }
        return super.m_5671_(stack);
    }

    private void updateData(ItemStack stack) {
        CompoundTag cmp;
        if (ItemNBTHelper.verifyExistence((ItemStack)stack, (String)"BlockEntityTag") && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)true)) != null) {
            if (cmp.m_128425_("angery", 99)) {
                boolean angry = cmp.m_128471_("angery");
                if (angry) {
                    ItemNBTHelper.setBoolean((ItemStack)stack, (String)"angery", (boolean)true);
                } else if (TinyPotatoBlock.isAngry(stack)) {
                    ItemNBTHelper.getNBT((ItemStack)stack).m_128473_("angery");
                }
                cmp.m_128473_("angery");
            }
            if (cmp.m_128425_("name", 8)) {
                stack.m_41714_((Component)Component.Serializer.m_130701_((String)cmp.m_128461_("name")));
                cmp.m_128473_("name");
            }
        }
        if (!ItemNBTHelper.getBoolean((ItemStack)stack, (String)"angery", (boolean)false)) {
            ItemNBTHelper.getNBT((ItemStack)stack).m_128473_("angery");
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.updateData(stack);
        return super.onEntityItemUpdate(stack, entity);
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity holder, int itemSlot, boolean isSelected) {
        this.updateData(stack);
        if (!world.f_46443_ && holder instanceof Player) {
            int ticks;
            Player player = (Player)holder;
            if (holder.f_19797_ % 30 == 0 && TYPOS.contains(ChatFormatting.m_126649_((String)stack.m_41611_().getString())) && (ticks = ItemNBTHelper.getInt((ItemStack)stack, (String)TICKS, (int)0)) < 17) {
                player.m_213846_((Component)Component.m_237115_((String)("quark.misc.you_came_to_the_wrong_neighborhood." + ticks)).m_130940_(ChatFormatting.RED));
                ItemNBTHelper.setInt((ItemStack)stack, (String)TICKS, (int)(ticks + 1));
            }
        }
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        if (stack.m_41788_() && TinyPotatoInfo.fromComponent(stack.m_41786_()).enchanted()) {
            return true;
        }
        return super.m_5812_(stack);
    }

    @Override
    public int getRuneColor(ItemStack stack) {
        if (stack.m_41788_()) {
            return TinyPotatoInfo.fromComponent(stack.m_41786_()).runeColor();
        }
        return -1;
    }
}

