/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block.pipe;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.addons.oddities.block.pipe.BasePipeBlock;
import vazkii.quark.base.module.QuarkModule;

public class PipeBlock
extends BasePipeBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape CENTER_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape UP_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
    private static final VoxelShape WEST_SHAPE = Shapes.m_83048_((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape EAST_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] shapeCache = new VoxelShape[64];
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public PipeBlock(QuarkModule module) {
        super("pipe", module);
    }

    @Override
    public BlockState getDefaultPipeState() {
        return (BlockState)super.getDefaultPipeState().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    boolean isPipeWaterlogged(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }

    @Override
    protected BlockState getTargetState(Level worldIn, BlockPos pos, boolean waterlog) {
        return (BlockState)super.getTargetState(worldIn, pos, waterlog).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlog));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return this.isPipeWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (this.isPipeWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            int ord = dir.ordinal();
            if (!((Boolean)state.m_61143_((Property)CONNECTIONS[ord])).booleanValue()) continue;
            index += 1 << ord;
        }
        VoxelShape cached = shapeCache[index];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = PipeBlock.isConnected(state, dir);
                if (!connected) continue;
                currShape = Shapes.m_83110_((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            PipeBlock.shapeCache[index] = currShape;
            cached = currShape;
        }
        return cached;
    }
}

