/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorField;

public class ReflectorFields {
    private ReflectorClass reflectorClass;
    private Class fieldType;
    private int fieldCount;
    private ReflectorField[] reflectorFields;

    public ReflectorFields(ReflectorClass reflectorClass, Class fieldType, int fieldCount) {
        this.reflectorClass = reflectorClass;
        this.fieldType = fieldType;
        this.fieldCount = fieldCount;
        if (!reflectorClass.exists()) {
            return;
        }
        if (fieldType == null) {
            return;
        }
        this.reflectorFields = new ReflectorField[fieldCount];
        for (int i2 = 0; i2 < this.reflectorFields.length; ++i2) {
            this.reflectorFields[i2] = new ReflectorField(reflectorClass, fieldType, i2);
        }
    }

    public ReflectorClass getReflectorClass() {
        return this.reflectorClass;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public ReflectorField getReflectorField(int index) {
        if (index < 0 || index >= this.reflectorFields.length) {
            return null;
        }
        return this.reflectorFields[index];
    }

    public Object getValue(Object obj, int index) {
        return Reflector.getFieldValue((Object)obj, (ReflectorFields)this, (int)index);
    }

    public void setValue(Object obj, int index, Object val) {
        Reflector.setFieldValue((Object)obj, (ReflectorFields)this, (int)index, (Object)val);
    }

    public boolean exists() {
        if (this.reflectorFields == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.reflectorFields.length; ++i2) {
            ReflectorField reflectorField = this.reflectorFields[i2];
            if (reflectorField.exists()) continue;
            return false;
        }
        return true;
    }
}

