/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomItemProperties;
import net.optifine.CustomItems;
import net.optifine.CustomItemsComparator;
import net.optifine.config.NbtTagValue;
import net.optifine.shaders.Shaders;
import net.optifine.util.EnchantmentUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static eyw itemModelGenerator = new eyw();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "item/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "item/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "item/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final Map<String, Integer> mapPotionDamages = CustomItems.makeMapPotionDamages();
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void update() {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (!Config.isCustomItems()) {
            return;
        }
        CustomItems.readCitProperties((String)"optifine/cit.properties");
        agt[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            agt rp = rps[i2];
            CustomItems.update((agt)rp);
        }
        CustomItems.update((agt)Config.getDefaultResourcePack());
        if (itemProperties.length <= 0) {
            itemProperties = null;
        }
        if (enchantmentProperties.length <= 0) {
            enchantmentProperties = null;
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            aaj loc = new aaj(fileName);
            InputStream in = Config.getResourceStream((aaj)loc);
            if (in == null) {
                return;
            }
            Config.dbg((String)("CustomItems: Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            useGlint = Config.parseBoolean((String)props.getProperty("useGlint"), (boolean)true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void update(agt rp) {
        CustomItemProperties[] cips;
        int i2;
        Object[] names = ResUtils.collectFiles((agt)rp, (String)"optifine/cit/", (String)".properties", null);
        Map mapAutoProperties = CustomItems.makeAutoImageProperties((agt)rp);
        if (mapAutoProperties.size() > 0) {
            Set keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray((Object[])names, (Object[])keysAuto);
        }
        Arrays.sort(names);
        List itemList = CustomItems.makePropertyList((CustomItemProperties[][])itemProperties);
        List enchantmentList = CustomItems.makePropertyList((CustomItemProperties[][])enchantmentProperties);
        for (int i3 = 0; i3 < names.length; ++i3) {
            Object name = names[i3];
            Config.dbg((String)("CustomItems: " + (String)name));
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = (CustomItemProperties)mapAutoProperties.get(name);
                }
                if (cip == null) {
                    aaj locFile = new aaj((String)name);
                    InputStream in = rp.a(agu.a, locFile);
                    if (in == null) {
                        Config.warn((String)("CustomItems file not found: " + (String)name));
                        continue;
                    }
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    cip = new CustomItemProperties((Properties)props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                CustomItems.addToItemList((CustomItemProperties)cip, (List)itemList);
                CustomItems.addToEnchantmentList((CustomItemProperties)cip, (List)enchantmentList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn((String)("CustomItems file not found: " + (String)name));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray((List)itemList);
        enchantmentProperties = CustomItems.propertyListToArray((List)enchantmentList);
        Comparator comp = CustomItems.getPropertiesComparator();
        for (i2 = 0; i2 < itemProperties.length; ++i2) {
            cips = itemProperties[i2];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
        for (i2 = 0; i2 < enchantmentProperties.length; ++i2) {
            cips = enchantmentProperties[i2];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
    }

    private static Comparator getPropertiesComparator() {
        1 comp = new /* Unavailable Anonymous Inner Class!! */;
        return comp;
    }

    public static void updateIcons(fif textureMap) {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.updateIcons(textureMap);
        }
    }

    public static void refreshIcons(fif textureMap) {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.refreshIcons(textureMap);
        }
    }

    public static void loadModels(fjw modelBakery) {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.loadModels(modelBakery);
        }
    }

    public static void updateModels() {
        List cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            if (cip.type != 1) continue;
            fif textureMap = Config.getTextureMap();
            cip.updateModelTexture(textureMap, itemModelGenerator);
            cip.updateModelsFull();
        }
    }

    private static List<CustomItemProperties> getAllProperties() {
        ArrayList<CustomItemProperties> list = new ArrayList<CustomItemProperties>();
        CustomItems.addAll((CustomItemProperties[][])itemProperties, list);
        CustomItems.addAll((CustomItemProperties[][])enchantmentProperties, list);
        return list;
    }

    private static void addAll(CustomItemProperties[][] cipsArr, List<CustomItemProperties> list) {
        if (cipsArr == null) {
            return;
        }
        for (int i2 = 0; i2 < cipsArr.length; ++i2) {
            CustomItemProperties[] cips = cipsArr[i2];
            if (cips == null) continue;
            for (int k2 = 0; k2 < cips.length; ++k2) {
                CustomItemProperties cip = cips[k2];
                if (cip == null) continue;
                list.add(cip);
            }
        }
    }

    private static Map<String, CustomItemProperties> makeAutoImageProperties(agt rp) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        map.putAll(CustomItems.makePotionImageProperties((agt)rp, (String)"normal", (aaj)hm.Y.b((Object)cac.qs)));
        map.putAll(CustomItems.makePotionImageProperties((agt)rp, (String)"splash", (aaj)hm.Y.b((Object)cac.ti)));
        map.putAll(CustomItems.makePotionImageProperties((agt)rp, (String)"linger", (aaj)hm.Y.b((Object)cac.tl)));
        return map;
    }

    private static Map<String, CustomItemProperties> makePotionImageProperties(agt rp, String type, aaj itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String typePrefix = type + "/";
        String[] prefixes = new String[]{"optifine/cit/potion/" + typePrefix, "optifine/cit/Potion/" + typePrefix};
        String[] suffixes = new String[]{".png"};
        String[] names = ResUtils.collectFiles((agt)rp, (String[])prefixes, (String[])suffixes);
        for (int i2 = 0; i2 < names.length; ++i2) {
            String path;
            String name = path = names[i2];
            Properties props = CustomItems.makePotionProperties((String)(name = StrUtils.removePrefixSuffix((String)name, (String[])prefixes, (String[])suffixes)), (String)type, (aaj)itemId, (String)path);
            if (props == null) continue;
            String pathProp = StrUtils.removeSuffix((String)path, (String[])suffixes) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, aaj itemId, String path) {
        if (StrUtils.endsWith((String)name, (String[])new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals("normal")) {
            itemId = hm.Y.b((Object)cac.qt);
            PropertiesOrdered props = new PropertiesOrdered();
            props.put("type", "item");
            props.put("items", itemId.toString());
            return props;
        }
        aaj potionItemId = itemId;
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn((String)("Potion not found for image: " + path));
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i2 = 0; i2 < damages.length; ++i2) {
            int damage = damages[i2];
            if (type.equals("splash")) {
                damage |= 0x4000;
            }
            if (i2 > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            damageMask |= 0x40;
        }
        PropertiesOrdered props = new PropertiesOrdered();
        props.put("type", "item");
        props.put("items", potionItemId.toString());
        props.put("damage", bufDamage.toString());
        props.put("damageMask", "" + damageMask);
        if (type.equals("splash")) {
            props.put("texture.potion_bottle_splash", name);
        } else {
            props.put("texture.potion_bottle_drinkable", name);
        }
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId((int)0, (int)0));
            mapPotionIds.put("awkward", CustomItems.getPotionId((int)0, (int)1));
            mapPotionIds.put("thick", CustomItems.getPotionId((int)0, (int)2));
            mapPotionIds.put("potent", CustomItems.getPotionId((int)0, (int)3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds((int)1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds((int)2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds((int)3));
            mapPotionIds.put("poison", CustomItems.getPotionIds((int)4));
            mapPotionIds.put("heal", CustomItems.getPotionIds((int)5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds((int)6));
            mapPotionIds.put("clear", CustomItems.getPotionId((int)7, (int)0));
            mapPotionIds.put("bungling", CustomItems.getPotionId((int)7, (int)1));
            mapPotionIds.put("charming", CustomItems.getPotionId((int)7, (int)2));
            mapPotionIds.put("rank", CustomItems.getPotionId((int)7, (int)3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds((int)8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds((int)9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds((int)10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds((int)11));
            mapPotionIds.put("harm", CustomItems.getPotionIds((int)12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds((int)13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds((int)14));
            mapPotionIds.put("thin", CustomItems.getPotionId((int)15, (int)0));
            mapPotionIds.put("debonair", CustomItems.getPotionId((int)15, (int)1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId((int)15, (int)2));
            mapPotionIds.put("stinky", CustomItems.getPotionId((int)15, (int)3));
            mapPotionIds.put("mundane", CustomItems.getPotionId((int)0, (int)4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "effect." + name;
        Set keys = hm.U.d();
        for (aaj rl : keys) {
            bah potion;
            String potionName;
            if (!hm.U.c(rl) || !fullName.equals(potionName = (potion = (bah)hm.U.a(rl)).d())) continue;
            return bah.a((bah)potion);
        }
        return -1;
    }

    private static List<List<CustomItemProperties>> makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<List<CustomItemProperties>> list = new ArrayList<List<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                CustomItemProperties[] props = propsArr[i2];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i2] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List<List<CustomItemProperties>> itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.items.length; ++i2) {
            int itemId = cp.items[i2];
            if (itemId <= 0) {
                Config.warn((String)("Invalid item ID: " + itemId));
                continue;
            }
            CustomItems.addToList((CustomItemProperties)cp, itemList, (int)itemId);
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List<List<CustomItemProperties>> enchantmentList) {
        if (cp.type != 2) {
            return;
        }
        if (cp.enchantmentIds == null) {
            return;
        }
        int countIds = CustomItems.getMaxEnchantmentId() + 1;
        for (int i2 = 0; i2 < countIds; ++i2) {
            int id = i2;
            if (!Config.equalsOne((int)id, (int[])cp.enchantmentIds)) continue;
            CustomItems.addToList((CustomItemProperties)cp, enchantmentList, (int)id);
        }
    }

    private static int getMaxEnchantmentId() {
        int maxId = 0;
        cdu enchantment;
        while ((enchantment = (cdu)hm.W.a(maxId)) != null) {
            ++maxId;
        }
        return maxId;
    }

    private static void addToList(CustomItemProperties cp, List<List<CustomItemProperties>> list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        List<CustomItemProperties> subList = list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static fjs getCustomItemModel(caa itemStack, fjs model, aaj modelLocation, boolean fullModel) {
        if (!fullModel && model.b()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties((caa)itemStack, (int)1);
        if (props == null) {
            return model;
        }
        fjs customModel = props.getBakedModel(modelLocation, fullModel);
        if (customModel != null) {
            return customModel;
        }
        return model;
    }

    public static aaj getCustomArmorTexture(caa itemStack, bav slot, String overlay, aaj locArmor) {
        if (itemProperties == null) {
            return locArmor;
        }
        aaj loc = CustomItems.getCustomArmorLocation((caa)itemStack, (bav)slot, (String)overlay);
        if (loc == null) {
            return locArmor;
        }
        return loc;
    }

    private static aaj getCustomArmorLocation(caa itemStack, bav slot, String overlay) {
        String key;
        aaj loc;
        CustomItemProperties props = CustomItems.getCustomItemProperties((caa)itemStack, (int)3);
        if (props == null) {
            return null;
        }
        if (props.mapTextureLocations == null) {
            return props.textureLocation;
        }
        bzw item = itemStack.c();
        if (!(item instanceof bxr)) {
            return null;
        }
        bxr itemArmor = (bxr)item;
        String material = itemArmor.d().d();
        int layer = slot == bav.d ? 2 : 1;
        StringBuffer sb = new StringBuffer();
        sb.append("texture.");
        sb.append(material);
        sb.append("_layer_");
        sb.append(layer);
        if (overlay != null) {
            sb.append("_");
            sb.append(overlay);
        }
        if ((loc = (aaj)props.mapTextureLocations.get(key = sb.toString())) == null) {
            return props.textureLocation;
        }
        return loc;
    }

    public static aaj getCustomElytraTexture(caa itemStack, aaj locElytra) {
        if (itemProperties == null) {
            return locElytra;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties((caa)itemStack, (int)4);
        if (props == null) {
            return locElytra;
        }
        if (props.textureLocation == null) {
            return locElytra;
        }
        return props.textureLocation;
    }

    private static CustomItemProperties getCustomItemProperties(caa itemStack, int type) {
        CustomItemProperties[] cips;
        CustomItemProperties[][] propertiesLocal = itemProperties;
        if (propertiesLocal == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        bzw item = itemStack.c();
        int itemId = bzw.a((bzw)item);
        if (itemId >= 0 && itemId < propertiesLocal.length && (cips = propertiesLocal[itemId]) != null) {
            for (int i2 = 0; i2 < cips.length; ++i2) {
                CustomItemProperties cip = cips[i2];
                if (cip.type != type || !CustomItems.matchesProperties((CustomItemProperties)cip, (caa)itemStack, null)) continue;
                return cip;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, caa itemStack, int[][] enchantmentIdLevels) {
        int i2;
        bzw item = itemStack.c();
        if (cip.damage != null) {
            int damage = CustomItems.getItemStackDamage((caa)itemStack);
            if (damage < 0) {
                return false;
            }
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int damageMax = item.n();
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.K())) {
            return false;
        }
        int[][] idLevels = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels((caa)itemStack);
            }
            boolean idMatch = false;
            for (i2 = 0; i2 < idLevels.length; ++i2) {
                int id = idLevels[i2][0];
                if (!Config.equalsOne((int)id, (int[])cip.enchantmentIds)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels((caa)itemStack);
            }
            boolean levelMatch = false;
            for (i2 = 0; i2 < idLevels.length; ++i2) {
                int level = idLevels[i2][1];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            pj nbt = itemStack.u();
            for (i2 = 0; i2 < cip.nbtTagValues.length; ++i2) {
                NbtTagValue ntv = cip.nbtTagValues[i2];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int getItemStackDamage(caa itemStack) {
        bzw item = itemStack.c();
        if (item instanceof cao) {
            return CustomItems.getPotionDamage((caa)itemStack);
        }
        return itemStack.j();
    }

    private static int getPotionDamage(caa itemStack) {
        pj nbt = itemStack.u();
        if (nbt == null) {
            return 0;
        }
        String name = nbt.l("Potion");
        if (name == null || name.equals("")) {
            return 0;
        }
        Integer value = (Integer)mapPotionDamages.get(name);
        if (value == null) {
            return -1;
        }
        int val = value;
        if (itemStack.c() == cac.ti) {
            val |= 0x4000;
        }
        return val;
    }

    private static Map<String, Integer> makeMapPotionDamages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomItems.addPotion((String)"water", (int)0, (boolean)false, map);
        CustomItems.addPotion((String)"awkward", (int)16, (boolean)false, map);
        CustomItems.addPotion((String)"thick", (int)32, (boolean)false, map);
        CustomItems.addPotion((String)"mundane", (int)64, (boolean)false, map);
        CustomItems.addPotion((String)"regeneration", (int)1, (boolean)true, map);
        CustomItems.addPotion((String)"swiftness", (int)2, (boolean)true, map);
        CustomItems.addPotion((String)"fire_resistance", (int)3, (boolean)true, map);
        CustomItems.addPotion((String)"poison", (int)4, (boolean)true, map);
        CustomItems.addPotion((String)"healing", (int)5, (boolean)true, map);
        CustomItems.addPotion((String)"night_vision", (int)6, (boolean)true, map);
        CustomItems.addPotion((String)"weakness", (int)8, (boolean)true, map);
        CustomItems.addPotion((String)"strength", (int)9, (boolean)true, map);
        CustomItems.addPotion((String)"slowness", (int)10, (boolean)true, map);
        CustomItems.addPotion((String)"leaping", (int)11, (boolean)true, map);
        CustomItems.addPotion((String)"harming", (int)12, (boolean)true, map);
        CustomItems.addPotion((String)"water_breathing", (int)13, (boolean)true, map);
        CustomItems.addPotion((String)"invisibility", (int)14, (boolean)true, map);
        return map;
    }

    private static void addPotion(String name, int value, boolean extended, Map<String, Integer> map) {
        if (extended) {
            value |= 0x2000;
        }
        map.put("minecraft:" + name, value);
        if (extended) {
            int valueStrong = value | 0x20;
            map.put("minecraft:strong_" + name, valueStrong);
            int valueLong = value | 0x40;
            map.put("minecraft:long_" + name, valueLong);
        }
    }

    private static int[][] getEnchantmentIdLevels(caa itemStack) {
        pp nbt;
        bzw item = itemStack.c();
        if (item == cac.ss) {
            bzb cfr_ignored_0 = (bzb)cac.ss;
            v0 = bzb.d((caa)itemStack);
        } else {
            v0 = nbt = itemStack.w();
        }
        if (nbt == null || nbt.size() <= 0) {
            return EMPTY_INT2_ARRAY;
        }
        int[][] arr = new int[nbt.size()][2];
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            int id;
            pj tag = nbt.a(i2);
            String idStr = tag.l("id");
            int lvl = tag.h("lvl");
            cdu en = EnchantmentUtils.getEnchantment((String)idStr);
            if (en == null) continue;
            arr[i2][0] = id = hm.W.a((Object)en);
            arr[i2][1] = lvl;
        }
        return arr;
    }

    public static boolean renderCustomEffect(fdl renderItem, caa itemStack, fjs model) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels((caa)itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean renderCustomArmorEffect(bbf entity, caa itemStack, eqb model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels((caa)itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }

    public static void setRenderOffHand(boolean renderOffHand) {
        CustomItems.renderOffHand = renderOffHand;
    }
}

